/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class NimRODScrollPaneUI
extends BasicScrollPaneUI {
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODScrollPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        if (jScrollPane.getHorizontalScrollBar() != null) {
            jScrollPane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        if (jScrollPane.getVerticalScrollBar() != null) {
            jScrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.oldOpaque = jScrollPane.isOpaque();
        jScrollPane.setOpaque(false);
        Component component = jScrollPane.getViewport().getView();
        if (component != null) {
            try {
                JComponent jComponent2 = (JComponent)component;
                if (jComponent2.getBorder() != null && jComponent2.getBorder() instanceof NimRODBorders.NimRODGenBorder) {
                    jComponent2.setBorder(null);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setOpaque(this.oldOpaque);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        Dimension dimension = jScrollPane.getSize();
        if (jScrollPane.getViewportBorder() != null) {
            Component component;
            for (component = jComponent.getParent(); component != null; component = component.getParent()) {
                if (!component.toString().startsWith("javax.swing.plaf.basic.BasicComboPopup")) continue;
                jScrollPane.setViewportBorder(null);
                break;
            }
            if ((component = jScrollPane.getViewport().getView()) != null) {
                try {
                    JComponent jComponent2 = (JComponent)component;
                    Border border = jScrollPane.getViewportBorder();
                    if (border != null && border instanceof NimRODBorders.NimRODGenBorder) {
                        int n = border.getBorderInsets((Component)jScrollPane).left + border.getBorderInsets((Component)jScrollPane).right - 1;
                        graphics.setColor(jComponent.getBackground());
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics.fillRoundRect(0, 0, n + component.getWidth(), jComponent.getHeight(), 7, 7);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                        jScrollPane.setPreferredSize(dimension);
                    }
                    if (jComponent2.getBorder() != null && jComponent2.getBorder() instanceof NimRODBorders.NimRODGenBorder) {
                        jComponent2.setBorder(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.paint(graphics, jComponent);
    }
}

