/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.script;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.ScriptFilter;
import com.group_finity.mascot.script.Variable;
import com.group_finity.mascot.script.VariableMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;

public class Script
extends Variable {
    private static final ScriptEngine engine = new NashornScriptEngineFactory().getScriptEngine((ClassFilter)new ScriptFilter());
    private final String source;
    private final boolean clearAtInitFrame;
    private final CompiledScript compiled;
    private Object value;

    public Script(String source, boolean clearAtInitFrame) throws VariableException {
        this.source = source;
        this.clearAtInitFrame = clearAtInitFrame;
        try {
            this.compiled = ((Compilable)((Object)engine)).compile(this.source);
        }
        catch (ScriptException e) {
            throw new VariableException(Main.getInstance().getLanguageBundle().getString("ScriptCompilationErrorMessage") + ": " + this.source, e);
        }
    }

    public String toString() {
        return this.isClearAtInitFrame() ? "#{" + this.getSource() + "}" : "${" + this.getSource() + "}";
    }

    @Override
    public void init() {
        this.setValue(null);
    }

    @Override
    public void initFrame() {
        if (this.isClearAtInitFrame()) {
            this.setValue(null);
        }
    }

    @Override
    public synchronized Object get(VariableMap variables) throws VariableException {
        if (this.getValue() != null) {
            return this.getValue();
        }
        try {
            this.setValue(this.getCompiled().eval(variables));
        }
        catch (ScriptException e) {
            throw new VariableException(Main.getInstance().getLanguageBundle().getString("ScriptEvaluationErrorMessage") + ": " + this.source, e);
        }
        return this.getValue();
    }

    private void setValue(Object value) {
        this.value = value;
    }

    private Object getValue() {
        return this.value;
    }

    private boolean isClearAtInitFrame() {
        return this.clearAtInitFrame;
    }

    private CompiledScript getCompiled() {
        return this.compiled;
    }

    private String getSource() {
        return this.source;
    }
}

