/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NimRODFontDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JPanel fondo;
    protected JList lFont;
    protected JList lStyle;
    protected JList lSize;
    protected Font currentFont;
    protected JLabel lEjemplo;
    protected boolean bCancelado = true;

    public NimRODFontDialog(Frame frame) {
        this(frame, (Font)null);
    }

    public NimRODFontDialog(Frame frame, Font font) {
        super(frame, "Font", true);
        this.setDefaultCloseOperation(2);
        this.doPanel(font);
        this.getContentPane().add((Component)this.fondo, "Center");
        this.pack();
        this.setResizable(false);
    }

    public boolean isCanceled() {
        return this.bCancelado;
    }

    public Font getSelectedFont() {
        return this.currentFont;
    }

    public void doPanel(Font font) {
        String[] stringArray = new String[]{"Normal", "Bold", "Italic", "Bold+Italic"};
        String[] stringArray2 = new String[100];
        for (int i = 1; i <= 100; ++i) {
            stringArray2[i - 1] = "" + i;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        MIListSelectionListener mIListSelectionListener = new MIListSelectionListener();
        this.lFont = new JList<String>(graphicsEnvironment.getAvailableFontFamilyNames());
        this.lFont.setVisibleRowCount(7);
        this.lFont.addListSelectionListener(mIListSelectionListener);
        this.lStyle = new JList<String>(stringArray);
        this.lStyle.setVisibleRowCount(7);
        this.lStyle.addListSelectionListener(mIListSelectionListener);
        this.lSize = new JList<String>(stringArray2);
        this.lSize.setVisibleRowCount(7);
        this.lSize.addListSelectionListener(mIListSelectionListener);
        JLabel jLabel = new JLabel("Font");
        jLabel.setBounds(10, 20, 41, 16);
        JLabel jLabel2 = new JLabel("Style");
        jLabel2.setBounds(170, 20, 41, 16);
        JLabel jLabel3 = new JLabel("Size");
        jLabel3.setBounds(270, 20, 41, 16);
        JScrollPane jScrollPane = new JScrollPane(this.lFont);
        jScrollPane.setBounds(10, 40, 150, 110);
        JScrollPane jScrollPane2 = new JScrollPane(this.lStyle);
        jScrollPane2.setBounds(170, 40, 90, 110);
        JScrollPane jScrollPane3 = new JScrollPane(this.lSize);
        jScrollPane3.setBounds(270, 40, 70, 110);
        this.lEjemplo = new JLabel("AaBbCcDdEeFfGgHhIiJjKkLlMm...XxYyZz", 0);
        this.lEjemplo.setBounds(10, 160, 340, 49);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(mIListSelectionListener);
        jButton.setBounds(265, 230, 75, 25);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(mIListSelectionListener);
        jButton2.setBounds(180, 230, 75, 25);
        this.fondo = new JPanel(null);
        this.fondo.add(jLabel);
        this.fondo.add(jLabel2);
        this.fondo.add(jLabel3);
        this.fondo.add(jScrollPane);
        this.fondo.add(jScrollPane2);
        this.fondo.add(jScrollPane3);
        this.fondo.add(this.lEjemplo);
        this.fondo.add(jButton);
        this.fondo.add(jButton2);
        this.fondo.setPreferredSize(new Dimension(350, 265));
        this.currentFont = font == null ? this.lEjemplo.getFont() : font;
        this.decode(this.currentFont);
    }

    private void decode(Font font) {
        String string = font.getFontName();
        int n = font.getStyle();
        int n2 = font.getSize();
        this.lFont.setSelectedValue(string, true);
        this.lSize.setSelectedValue("" + n2, true);
        if ((n & 1) != 0 && (n & 2) != 0) {
            this.lStyle.setSelectedValue("Bold+Italic", true);
        } else if ((n & 1) != 0) {
            this.lStyle.setSelectedValue("Bold", true);
        } else if ((n & 2) != 0) {
            this.lStyle.setSelectedValue("Italic", true);
        } else {
            this.lStyle.setSelectedValue("Normal", true);
        }
    }

    public void refresh() {
        this.lEjemplo.setFont(this.currentFont);
    }

    protected class MIListSelectionListener
    implements ListSelectionListener,
    ActionListener {
        protected MIListSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("OK")) {
                NimRODFontDialog.this.bCancelado = false;
            } else if (actionEvent.getActionCommand().equals("Cancel")) {
                NimRODFontDialog.this.bCancelado = true;
            }
            NimRODFontDialog.this.dispose();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string = NimRODFontDialog.this.currentFont.getFontName();
            int n = NimRODFontDialog.this.currentFont.getStyle();
            int n2 = NimRODFontDialog.this.currentFont.getSize();
            if (NimRODFontDialog.this.lFont.getSelectedValue() != null) {
                string = (String)NimRODFontDialog.this.lFont.getSelectedValue();
            }
            if (NimRODFontDialog.this.lSize.getSelectedValue() != null) {
                n2 = Integer.decode((String)NimRODFontDialog.this.lSize.getSelectedValue());
            }
            if (NimRODFontDialog.this.lStyle.getSelectedValue() != null) {
                n = 0;
                String string2 = (String)NimRODFontDialog.this.lStyle.getSelectedValue();
                if (string2.indexOf("Normal") != -1) {
                    n = 0;
                } else {
                    if (string2.indexOf("Italic") != -1) {
                        n = 2;
                    }
                    if (string2.indexOf("Bold") != -1) {
                        n |= 1;
                    }
                }
            }
            NimRODFontDialog.this.currentFont = new Font(string, n, n2);
            NimRODFontDialog.this.refresh();
        }
    }
}

